attribute vec2 a_position;
attribute vec4 a_color;
attribute vec2 a_texcoord;

uniform mat4 u_modelMtx;
uniform mat4 u_viewMtx;
uniform mat4 u_projMtx;

uniform vec4 u_blendcolor;

uniform float time;
uniform float stiffness;
uniform float windStrength;

varying vec2 v_texcoord;
varying vec4 v_color;


void main()
{
    v_texcoord  = a_texcoord;
	v_color = u_blendcolor;
	
	vec2 vPosition = a_position;
	if (a_texcoord.y > 0.3) 
		vPosition.x += sin(time/stiffness+vPosition.y) * windStrength * 0.1;
	
	// gl_FrontColor = a_color;
	gl_Position = u_projMtx * u_viewMtx * u_modelMtx * vec4(a_position,0.0,1.0);

	// Transforming The Vertex
	// gl_Position = ftransform();
} 
